IF OBJECT_ID('UFD_EXP_CTB_MOV_CHQ_REDEPOS') IS NOT NULL
	BEGIN
		DROP FUNCTION UFD_EXP_CTB_MOV_CHQ_REDEPOS
	END
	
GO	
 
 
CREATE FUNCTION UFD_EXP_CTB_MOV_CHQ_REDEPOS(@CD_EMP		 INT,
											@CD_FILIAL 	 INT,
											@DT_INI		 DATETIME,
											@DT_FIM		 DATETIME)		
RETURNS @RS_RETURN TABLE(
			CD_EMP					INT,
			CD_FILIAL				INT,
			CD_CNT					INT, 
			VALORCHEQUES			MONEY, 
			NR_CHQ					INT, 
			SR_CHQ					VARCHAR(2), 
			ANO_CHQ					INT,
			CD_CHQ					INT,
			DT_REDEPOS				DATETIME,
			CD_BC_LANC                  INT )			
AS
BEGIN       
	
	DECLARE @CD_GRP_ECON			INT
	
	SET @CD_GRP_ECON = (SELECT PRC_GRP_ECON_PRC_FILIAL.CD_GRP_ECON
						FROM PRC_FILIAL
							INNER JOIN PRC_GRP_ECON_PRC_FILIAL ON
								PRC_FILIAL.CD_EMP = PRC_GRP_ECON_PRC_FILIAL.CD_EMP AND 
								PRC_FILIAL.CD_FILIAL = PRC_GRP_ECON_PRC_FILIAL.CD_FILIAL
						WHERE
						    PRC_FILIAL.CD_EMP = @CD_EMP
						    AND PRC_FILIAL.CD_FILIAL = @CD_FILIAL
						    AND PRC_FILIAL.FILIAL_MTZ_GRP_ECON = 1)
	
	IF ISNULL(@CD_GRP_ECON,0) = 0 
		BEGIN
			RETURN
		END
		
	INSERT INTO @RS_RETURN 	
		SELECT 
			BC_LANC.CD_EMP,
			@CD_FILIAL AS CD_FILIAL,
			BC_LANC.CD_CNT, 
			BC_LANC.VLR_LANC AS VALORCHEQUES, 
			CHQ_LANC_CPL.NR_CHQ, 
			CHQ_LANC_CPL.SR_CHQ, 
			CHQ_LANC_CPL.ANO_CHQ,
			CHQ_LANC_CPL.CD_CHQ,
			CHQ_REDEPOS.DT_REDEPOS,
			BC_LANC.CD_BC_LANC			
		FROM CHQ_LANC_CPL 
		INNER JOIN CHQ_REDEPOS ON 
			CHQ_LANC_CPL.CD_EMP = CHQ_REDEPOS.CD_EMP AND 
			CHQ_LANC_CPL.CD_CHQ = CHQ_REDEPOS.CD_CHQ 
		INNER JOIN BC_LANC_CHQ_REDEPOS 
		INNER JOIN BC_CONTAS_PRC_GRP_ECON 
		INNER JOIN BC_LANC ON 
			BC_CONTAS_PRC_GRP_ECON.CD_EMP = BC_LANC.CD_EMP AND 
			BC_CONTAS_PRC_GRP_ECON.CD_CNT = BC_LANC.CD_CNT ON
			BC_LANC_CHQ_REDEPOS.CD_EMP = BC_LANC.CD_EMP AND 
			BC_LANC_CHQ_REDEPOS.CD_BC_LANC = BC_LANC.CD_BC_LANC ON
			CHQ_REDEPOS.CD_EMP = BC_LANC_CHQ_REDEPOS.CD_EMP AND
			CHQ_REDEPOS.CD_REDEPOS = BC_LANC_CHQ_REDEPOS.CD_REDEPOS
	    
		WHERE 
			BC_LANC.CD_EMP = @CD_EMP 
			AND BC_CONTAS_PRC_GRP_ECON.CD_GRP_ECON = @CD_GRP_ECON
			AND BC_LANC.TP_LANC = 0
			AND CHQ_REDEPOS.DT_REDEPOS BETWEEN @DT_INI AND @DT_FIM 
	    
		ORDER BY BC_LANC.CD_CNT		
    
   RETURN
    
END    